state OldGodsSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var stormbase										: W3SpellsStorm;

	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("magic_sorceress.bnk") )
		{
			theSound.SoundLoadBank( "magic_sorceress.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("amb_dyn_bob_electric_cage.bnk") )
		{
			theSound.SoundLoadBank( "amb_dyn_bob_electric_cage.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_keira.bnk") )
		{
			theSound.SoundLoadBank( "magic_keira.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_man_mage.bnk") )
		{
			theSound.SoundLoadBank( "magic_man_mage.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("fx_enviro.bnk") )
		{
			theSound.SoundLoadBank( "fx_enviro.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("sq_sk_205.bnk") )
		{
			theSound.SoundLoadBank( "sq_sk_205.bnk", false );
		}
	
		//if ( parent.spell_name == 'winter_souls_tornado' )
		//{
		//	thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		//}
		//else
		
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
		
		if ( !parent.storm_is_active && parent.spell_name == 'old_gods_storm' )
		{
			thePlayer.SoundEvent('sq_sk_205_short_gusty');thePlayer.SoundEvent('sq_sk_205_short_gusty');thePlayer.SoundEvent('sq_sk_205_short_gusty');
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		if ( animEventName == 'cast_throw' )
		{
			cast_spells_oldgods();
			if ( parent.spell_name != 'winter_souls_tornado' )
			{
				thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
			}
		}
		if ( animEventName == 'cast_end' )
		{
			cast_spells_sunspear();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	
	private function cast_spells_oldgods()
	{
		var basePos, pos			: Vector;
		var rot 					: EulerAngles;
		var spikeEnt				: CEntity;
		var PositionLocal			: Vector;
		var PositionGlobal			: Vector;
		var polarAngle, unitAngle 	: float;
		var radius, angle		 	: float;
		var effect_expl				: CEntity;
		
		switch( parent.spell_name )
		{
			case 'old_gods_storm':
				{
					if ( !parent.storm_is_active && parent.spell_name == 'old_gods_storm' )
					{
						stormbase = (W3SpellsStorm)theGame.CreateEntity((CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\old_gods_storm_effect.w2ent",true), 
						thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation() );
						stormbase.AddTag('old_gods_storm_base');
						stormbase.PushState('OldGodsStorm');
						
						Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					}
				}

				break;
			case 'old_gods_stream':
				{
					parent.templatename = "dlc\magicspellsrev\data\entities\old_gods.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), thePlayer.GetWorldPosition() );
					main_effect.PlayEffect('old_gods_stream');
					main_effect.CreateAttachment( thePlayer, 'l_weapon');
					main_effect.AddTag('spells_alt_stream');
					
					parent.stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_cost_per_sec', false, true ) * 0.5 );
					parent.stamina_cost += parent.stamina_cost * get_stamina_cost_mult_streams(); 
					
					parent.stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_delay', false, true ) );
					parent.stamina_delay += parent.stamina_delay * get_stamina_delay_mult(); 
					
					register_cancel_input_spells();
					
					parent.stream_hits.Clear();
					
					cast_spells_stream_oldgods();
				}

				break;
			case 'electric_blast':
				{
					
					position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward();
					position = TraceFloor( position );
					position.Z += 1.5;
					
					parent.templatename = "dlc\magicspellsrev\data\entities\old_gods_blast.w2ent";
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, thePlayer.GetWorldRotation() );
					main_effect.PlayEffect( 'blast_lv2' );
					main_effect.StopEffect( 'blast_lv2' );
					
					main_effect.PlayEffect( 'blast_lv1' );
					main_effect.PlayEffect( 'blast_lv11' );
					
					main_effect.DestroyAfter(10);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
					thePlayer.PlayEffect('mutation_1_quen_power');
					main_effect.SoundEvent('magic_keira_lightning');
					main_effect.SoundEvent('fx_other_lightning_pre_2s');
					
					GCameraShake( 0.4, true, position, 30.0f);
					
					actors = thePlayer.GetNPCsAndPlayersInRange( 8.1, 100, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
					for( i = 0; i < actors.Size(); i += 1 )
					{
						target = (CActor)actors[i];
						damage_value = get_damage_value_for_blasts( target, GetMagicVigil().get_magic_spellpower() );
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitReactionType(EHRT_Heavy);
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage_value );
						damage_action.AddEffectInfo( EET_Stagger );
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						effect_entity = target.CreateFXEntityAtPelvis( 'explosions', true );
						effect_entity.PlayEffect( 'old_gods_hit' );
						effect_entity.DestroyAfter(5);
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
						
						if( !target.IsAlive() )
						{
							effect_expl = target.CreateFXEntityAtPelvis( 'explosions', true );
							effect_expl.SoundEvent("magic_man_fx_lightning");
							effect_expl.PlayEffect( 'mutation_2_quen' );
							effect_expl.DestroyAfter(5);
						}
					}
				}
				
				break;
			default:		
				break;
		}
	}
	
		
	private entry function cast_spells_stream_oldgods()
	{
		var damage_action_stream				: W3DamageAction;
		var victims 							: array<CActor>;
		var victim								: CActor;
		var damage 								: float;
		var channelDmg 							: SAbilityAttributeValue;
		var i									: int;
		var castDir								: Vector;
		var targetPosition						: Vector;
		var position							: Vector;
		var slotMatrix 							: Matrix;
		var effectentity, effectsound1			: CEntity;
		var effect_expl                         : CEntity;
		var coll, normal 						: Vector;
		var lastpos 							: Vector;
		var lastpos2 							: Vector;
		var entities							: array<CGameplayEntity>;
		
		effectsound1 = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\energy_body_electricity.w2ent",true), thePlayer.GetWorldPosition() );
		effectsound1.SoundEvent("amb_dyn_bob_electric_cage_fx_start");
		effectsound1.SoundEvent("amb_dyn_bob_electric_cage_fx_start");
		effectsound1.SoundEvent("amb_dyn_bob_electric_cage_fx_start");
		effectsound1.SoundEvent("amb_dyn_bob_electric_cage_fx_start");
		effectsound1.SoundEvent("magic_keira_hand_fx_electricity_loop_start");
		effectsound1.SoundEvent("sign_igni_charge_loop_play");
		effectsound1.CreateAttachment( GetMagicEffectLeft() );
		effectsound1.AddTag('spells_stream_collision_sound1');
		
		while ( true )
		{
			if (  thePlayer.GetStatPercents( BCS_Stamina ) > 0.01f && thePlayer.GetBehaviorVariable	( 'IsCastingSign' ) == 1 )
			{
				thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
				position = MatrixGetTranslation(slotMatrix);
				
				castDir 		= MatrixGetAxisX( thePlayer.GetBoneWorldMatrixByIndex( thePlayer.GetBoneIndex( 'l_weapon' ) ) );
				targetPosition  = position + ( 6 * castDir );
				
				parent.hand_aim_position = position;
				parent.hand_aim_direction = castDir;
			
				FindGameplayEntitiesInCone( entities, position, VecHeading( castDir ), 25, 6, 100 );
			
				for (i=0; i<entities.Size(); i+=1)			
				{
					if ( !parent.stream_hits.Contains( entities[i] ) && !entities[i].HasTag('spells_custom_projs') )
					{
						entities[i].OnAardHit( NULL );
						parent.stream_hits.PushBack( entities[i] );
					}
				}
			
				victims = thePlayer.GetNPCsAndPlayersInCone( 6, VecHeading( castDir ), 25, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
				for (i=0; i<victims.Size(); i+=1)			
				{
					victim = (CActor)victims[i];
					if ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive() )
					{
						damage = get_damage_value_for_stream( victim, GetMagicVigil().get_magic_spellpower() );
						damage *= theTimer.timeDelta;
					
						damage_action_stream = new W3DamageAction in this;
						damage_action_stream.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_SpellPower,false, false, true, false );
						damage_action_stream.SetProcessBuffsIfNoDamage(true);
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							damage *= 0.5;
							
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 4 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						else
						{
							if( RandF()<0.1 ) 
							{ 
								damage_action_stream.AddEffectInfo( EET_Burning, 1 ); 
							}
						}
						
						damage_action_stream.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage * 0.5 );
						damage_action_stream.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() *  damage * 0.5 );
						damage_action_stream.AddEffectInfo(EET_SpellsSlowDownAverage, 1 );
						
						damage_action_stream.SetIsDoTDamage( theTimer.timeDelta );
							
						damage_action_stream.SetHitAnimationPlayType(EAHA_ForceNo);
						damage_action_stream.SetHitEffect('');
						damage_action_stream.SetHitEffect('', true );
						damage_action_stream.SetHitEffect('', false, true);
						damage_action_stream.SetHitEffect('', true, true);
						
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action_stream.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action_stream );
						delete damage_action_stream;
						
						if( !victim.IsAlive() )
						{
							effect_expl = victim.CreateFXEntityAtPelvis( 'explosions', true );
							effect_expl.PlayEffect( 'mutation_2_quen' );
							effect_expl.SoundEvent("magic_man_fx_lightning");
							effect_expl.DestroyAfter(5);
						}
					}
				}
				
				if( theGame.GetWorld().SweepTest( position + castDir, targetPosition, 0.3, coll, normal, parent.collisions_stream ) )
				{
					lastpos = coll;
					theGame.GetEntityByTag( 'spells_stream_collision' ).PlayEffect('collision_fx');
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).StopAllEffects();
				}
				
				if ( !theGame.GetEntityByTag( 'spells_stream_collision' ) )
				{
					effectentity = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\old_gods_stream_collision.w2ent",true), targetPosition, thePlayer.GetWorldRotation() );
					effectentity.AddTag('spells_stream_collision');
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(lastpos);
				}
				
				GetWitcherPlayer().DrainStamina( ESAT_FixedValue, parent.stamina_cost * theTimer.timeDelta, parent.stamina_delay ); 
			}
			else
			{
				thePlayer.SoundEvent("gui_no_stamina");
				parent.PushState('Vigil_Dreaming');
			}
			
			Sleep( theTimer.timeDelta );
		}
	
	}
	
	
	
	private function cast_spells_sunspear()
	{
		var vector_attach 	: Vector;
		var sunspear 		: W3SunSpear;
	
		if ( parent.spell_name == 'sunspear' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				targetPosition = parent.actor.GetBoneWorldPosition( spells_get_pelvis_name( parent.actor ) );
				targetPosition.Z += 0.3;
			
				parent.templatename = "dlc\magicspellsrev\data\entities\old_gods_sunspear.w2ent";

				vector_attach = Vector( -0.2, 0.07, 0.05 );

				sunspear = (W3SunSpear)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), thePlayer.GetWorldPosition() );
				sunspear.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				sunspear.AddTag( 'spells_custom_projs' );
				sunspear.AddTag( 'spells_from_sign' );
				sunspear.Init(NULL);
				sunspear.PlayEffect( 'fire_fx' );
				sunspear.PlayEffect( 'fire_fx2' );
				sunspear.BreakAttachment();
				sunspear.ShootProjectileAtPosition(0, 15, targetPosition );
				sunspear.DestroyAfter(10);

				effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'old_gods_effects' ), thePlayer.GetWorldPosition() ) ;
				effect_entity.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				effect_entity.PlayEffect( 'old_gods_shot' );
				effect_entity.DestroyAfter(3);
				
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
				thePlayer.SetCombatIdleStance( 1.f );
			}
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}